
// BIUser.h
// BISubstrate
// 
// Copyright (c) 2001 Marketcircle Inc. All rights reserved.

/*!
    @class       BIUser
    @abstract    BIUser represents a user within Billings.
    @discussion  A user has clients, and the user is essentially the root object for everything.  Top of the tree.
*/


#ifdef BILLINGS_PRO
#import "_BPUser.h"
#endif
#ifdef BILLINGS_SINGLE
#import "_BIUser.h"
#endif
#import "BIAppVersioning.h"

#import <MCFoundation/MCPUserProtocol.h>

@class ABPerson;

@interface BIUser : BL_SUPER_CLASSNAME_MUNGE(User) <MCPUserProtocol>
{
}

- (NSString *)workerName;
- (NSString *)lastName;
- (NSString *)firstName;

#ifdef BILLINGS_PRO
- (NSString *)displayNameForApprovalsPopup;
#endif
@end
